/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.util.block;

import com.starfish_studios.another_furniture.registry.AFItemTags;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface HammerableBlock {
    default public boolean tryHammerBlock(Property<?> property, ItemStack stack, BlockState state, LevelAccessor level, BlockPos pos, Player player) {
        if (property == null || !state.hasProperty(property)) {
            return false;
        }
        if (!stack.is(AFItemTags.FURNITURE_HAMMER)) {
            return false;
        }
        state = (BlockState)state.cycle(property);
        state = this.updateAfterCycle(state, level, pos);
        level.setBlock(pos, state, 3);
        level.playSound(null, pos, this.getUseSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    default public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return state;
    }

    default public SoundEvent getUseSound() {
        return AFSoundEvents.HAMMER_USE.get();
    }
}

